using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.Threading;

using Microsoft.DirectX;
using Microsoft.DirectX.DirectInput;
using Microsoft.DirectX.DirectPlay;

using DarkStrideToolbox;
using DarkStride.StellarLanes.SharedDLL;

namespace DarkStride.StellarLanes.Server
{
	public class frmMain : System.Windows.Forms.Form
	{
		#region Properties
        private DateTime m_dtLastLargePacketSend = DateTime.MinValue;
        private System.Collections.Generic.List<DSNetworkPacket> m_oLargePacketsToSend = new System.Collections.Generic.List<DSNetworkPacket>();

		private FileServerUpdater m_oFileServerUpdater = null;
		private DSGameEngine m_oGameEngine = null;

		private DSSortedList m_oActiveSessions = new DSSortedList();
		private DSSortedList m_oInActiveSessions = new DSSortedList();
		private DSSortedList m_oPlayerSocketIDToSessionGUIDLookup = new DSSortedList();

		private const int m_cDEFAULTPORT = 5461;
		private string m_sServerName = "";

		private long m_nNextSessionNumberToUse = 1;

        private delegate void DelegateLogEvent(string sLogMsg);
        private delegate void DelegatePlayerJoined(DSNetworkPlayer oNewPlayer, bool bUs);
        private delegate void DelegateRemovePlayerFromSession(DSNetworkPlayer oPlayerToRemove);
        private delegate int DelegateGetPlayerIndexInListView(long nSocketID);
        private delegate void DelegateRemoveUser(long nSocketID);        
		#endregion

		#region System Stuff
		private System.Windows.Forms.ImageList imgIcons;
		private System.Windows.Forms.GroupBox grpSession;
		private System.Windows.Forms.ListView lvwSessions;
		private System.Windows.Forms.ColumnHeader clmnhName;
		private System.Windows.Forms.ColumnHeader clmnhUserCount;
		private System.Windows.Forms.Button cmdStopSession;
		private System.Windows.Forms.Button cmdStartSession;
		private System.Windows.Forms.ListBox lstLog;
		private System.Windows.Forms.Label lblLog;
		private System.Windows.Forms.Button cmdSendLobbyMsg;
		private System.Windows.Forms.TextBox txtSendMsg;
		private System.Windows.Forms.ListView lvwUsers;
		private System.Windows.Forms.ColumnHeader clmnhUserName;
		private System.Windows.Forms.ColumnHeader clmnhUserStatus;
		private System.ComponentModel.IContainer components;

		public frmMain()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(frmMain));
			this.imgIcons = new System.Windows.Forms.ImageList(this.components);
			this.grpSession = new System.Windows.Forms.GroupBox();
			this.lvwUsers = new System.Windows.Forms.ListView();
			this.clmnhUserName = new System.Windows.Forms.ColumnHeader();
			this.clmnhUserStatus = new System.Windows.Forms.ColumnHeader();
			this.cmdSendLobbyMsg = new System.Windows.Forms.Button();
			this.txtSendMsg = new System.Windows.Forms.TextBox();
			this.lblLog = new System.Windows.Forms.Label();
			this.lstLog = new System.Windows.Forms.ListBox();
			this.cmdStopSession = new System.Windows.Forms.Button();
			this.cmdStartSession = new System.Windows.Forms.Button();
			this.lvwSessions = new System.Windows.Forms.ListView();
			this.clmnhName = new System.Windows.Forms.ColumnHeader();
			this.clmnhUserCount = new System.Windows.Forms.ColumnHeader();
			this.grpSession.SuspendLayout();
			this.SuspendLayout();
			// 
			// imgIcons
			// 
			this.imgIcons.ImageSize = new System.Drawing.Size(16, 16);
			this.imgIcons.ImageStream = ((System.Windows.Forms.ImageListStreamer)(resources.GetObject("imgIcons.ImageStream")));
			this.imgIcons.TransparentColor = System.Drawing.Color.Transparent;
			// 
			// grpSession
			// 
			this.grpSession.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpSession.Controls.Add(this.lvwUsers);
			this.grpSession.Controls.Add(this.cmdSendLobbyMsg);
			this.grpSession.Controls.Add(this.txtSendMsg);
			this.grpSession.Controls.Add(this.lblLog);
			this.grpSession.Controls.Add(this.lstLog);
			this.grpSession.Controls.Add(this.cmdStopSession);
			this.grpSession.Controls.Add(this.cmdStartSession);
			this.grpSession.Controls.Add(this.lvwSessions);
			this.grpSession.Location = new System.Drawing.Point(8, 8);
			this.grpSession.Name = "grpSession";
			this.grpSession.Size = new System.Drawing.Size(528, 352);
			this.grpSession.TabIndex = 14;
			this.grpSession.TabStop = false;
			this.grpSession.Text = "Sessions";
			// 
			// lvwUsers
			// 
			this.lvwUsers.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lvwUsers.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
			this.lvwUsers.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																					   this.clmnhUserName,
																					   this.clmnhUserStatus});
			this.lvwUsers.FullRowSelect = true;
			this.lvwUsers.Location = new System.Drawing.Point(408, 88);
			this.lvwUsers.Name = "lvwUsers";
			this.lvwUsers.Size = new System.Drawing.Size(112, 160);
			this.lvwUsers.TabIndex = 37;
			this.lvwUsers.View = System.Windows.Forms.View.Details;
			// 
			// clmnhUserName
			// 
			this.clmnhUserName.Text = "User";
			// 
			// clmnhUserStatus
			// 
			this.clmnhUserStatus.Text = "Status";
			this.clmnhUserStatus.Width = 52;
			// 
			// cmdSendLobbyMsg
			// 
			this.cmdSendLobbyMsg.FlatStyle = System.Windows.Forms.FlatStyle.Flat;
			this.cmdSendLobbyMsg.Location = new System.Drawing.Point(472, 320);
			this.cmdSendLobbyMsg.Name = "cmdSendLobbyMsg";
			this.cmdSendLobbyMsg.Size = new System.Drawing.Size(48, 20);
			this.cmdSendLobbyMsg.TabIndex = 35;
			this.cmdSendLobbyMsg.Text = "Send";
			this.cmdSendLobbyMsg.Click += new System.EventHandler(this.cmdSendLobbyMsg_Click);
			// 
			// txtSendMsg
			// 
			this.txtSendMsg.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
			this.txtSendMsg.Location = new System.Drawing.Point(16, 320);
			this.txtSendMsg.Name = "txtSendMsg";
			this.txtSendMsg.Size = new System.Drawing.Size(453, 20);
			this.txtSendMsg.TabIndex = 34;
			this.txtSendMsg.Text = "";
			// 
			// lblLog
			// 
			this.lblLog.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
			this.lblLog.Location = new System.Drawing.Point(16, 248);
			this.lblLog.Name = "lblLog";
			this.lblLog.Size = new System.Drawing.Size(128, 16);
			this.lblLog.TabIndex = 18;
			this.lblLog.Text = "Log:";
			// 
			// lstLog
			// 
			this.lstLog.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lstLog.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
			this.lstLog.Location = new System.Drawing.Point(16, 264);
			this.lstLog.Name = "lstLog";
			this.lstLog.Size = new System.Drawing.Size(504, 54);
			this.lstLog.TabIndex = 17;
			// 
			// cmdStopSession
			// 
			this.cmdStopSession.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.cmdStopSession.Enabled = false;
			this.cmdStopSession.FlatStyle = System.Windows.Forms.FlatStyle.Flat;
			this.cmdStopSession.ImageAlign = System.Drawing.ContentAlignment.BottomLeft;
			this.cmdStopSession.ImageIndex = 0;
			this.cmdStopSession.ImageList = this.imgIcons;
			this.cmdStopSession.Location = new System.Drawing.Point(408, 56);
			this.cmdStopSession.Name = "cmdStopSession";
			this.cmdStopSession.Size = new System.Drawing.Size(104, 24);
			this.cmdStopSession.TabIndex = 16;
			this.cmdStopSession.Text = "      Stop Session";
			this.cmdStopSession.Click += new System.EventHandler(this.cmdStopSession_Click);
			// 
			// cmdStartSession
			// 
			this.cmdStartSession.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.cmdStartSession.FlatStyle = System.Windows.Forms.FlatStyle.Flat;
			this.cmdStartSession.ImageAlign = System.Drawing.ContentAlignment.MiddleLeft;
			this.cmdStartSession.ImageIndex = 1;
			this.cmdStartSession.ImageList = this.imgIcons;
			this.cmdStartSession.Location = new System.Drawing.Point(408, 24);
			this.cmdStartSession.Name = "cmdStartSession";
			this.cmdStartSession.Size = new System.Drawing.Size(104, 24);
			this.cmdStartSession.TabIndex = 15;
			this.cmdStartSession.Text = "      Start Session";
			this.cmdStartSession.Click += new System.EventHandler(this.cmdStartSession_Click);
			// 
			// lvwSessions
			// 
			this.lvwSessions.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lvwSessions.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
			this.lvwSessions.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																						  this.clmnhName,
																						  this.clmnhUserCount});
			this.lvwSessions.FullRowSelect = true;
			this.lvwSessions.Location = new System.Drawing.Point(16, 24);
			this.lvwSessions.Name = "lvwSessions";
			this.lvwSessions.Size = new System.Drawing.Size(384, 224);
			this.lvwSessions.TabIndex = 14;
			this.lvwSessions.View = System.Windows.Forms.View.Details;
			this.lvwSessions.SelectedIndexChanged += new System.EventHandler(this.lvwSessions_SelectedIndexChanged);
			// 
			// clmnhName
			// 
			this.clmnhName.Text = "Name";
			this.clmnhName.Width = 260;
			// 
			// clmnhUserCount
			// 
			this.clmnhUserCount.Text = "# Users";
			// 
			// frmMain
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(544, 365);
			this.Controls.Add(this.grpSession);
			this.Name = "frmMain";
			this.Text = "App Server";
			this.Closing += new System.ComponentModel.CancelEventHandler(this.frmMain_Closing);
			this.grpSession.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			try
			{
				using( frmMain oApp = new frmMain() )
				{   
					oApp.DSGameEngine = new DSGameEngine( null,"",true );
					oApp.DSGameEngine.FrameMove += new EventHandler( oApp.Advance );
					//oApp.DSGameEngine.DirectInput.MouseInExclusiveMode = false;
					oApp.DSGameEngine.OneTimeSceneInitialization += new EventHandler( oApp.OneTimeSceneInitialization );
					//oApp.DSGameEngine.SetDeviceStates += new EventHandler( oApp.SetDeviceStates );
					oApp.Show();
					oApp.DSGameEngine.Run();
				}
			}
			catch( System.Exception oEx )
			{
				DSMisc.ShowErrors( oEx );
			}
		}
		#endregion


        public void OneTimeSceneInitialization(object sender, System.EventArgs e)
        {
            //ServiceProviderInformation oServiceProv;
            frmStartServer oStartDlg = new frmStartServer();
            frmPleaseWait oPleaseWait = null;
            DSGobFile oGobFile = null;
            string sFileName = "";


            DSBufferDebug.Inst().DebugPath = m_oGameEngine.DebugPath;
            DSBufferDebug.Inst().DebugMode = m_oGameEngine.DebugMode;

            //Now go through and show all the services available
            m_oGameEngine.MaxFPS = 30;
            m_oGameEngine.DirectPlay.Initialize(MiscConstants.m_cAPPGUID, System.Net.Sockets.ProtocolType.Udp);
            /*if( m_oGameEngine.DirectPlay.Initialize( MiscConstants.m_cAPPGUID,System.Net.Sockets.ProtocolType.Tcp ) == false )
            {
                throw new System.Exception( "Failed to initialize DirectX.DirectPlay network." );
            }*/
            m_oGameEngine.DirectPlay.RegisterDelegate_DataReceived(new DSNetworkWrapper.CallbackDataReceived(this.DataReceived));
            m_oGameEngine.DirectPlay.RegisterDelegate_PlayerJoined(new DSNetworkWrapper.CallbackPlayerJoined(this.PlayerJoined));
            m_oGameEngine.DirectPlay.RegisterDelegate_PlayerQuit(new DSNetworkWrapper.CallbackPlayerQuit(this.PlayerQuit));

            //Setup our network
            NetMsg.StopObsoletePackets(m_oGameEngine.DirectPlay);

            //Load our game data
            oGobFile = new DSGobFile();
            if (System.Diagnostics.Debugger.IsAttached == true)
            {
                sFileName = DSMisc.GetDevelopmentAppPath() + @"..\StellarLanes.gob";
            }
            else
            {
                sFileName = DSMisc.GetDevelopmentAppPath() + @"StellarLanes.gob";
            }
            oGobFile.LoadGobFile(sFileName, GobConstants.m_cGOBNAME);

            //Now start a service
            oStartDlg.ServerName = "New World Order";
            oStartDlg.Port = m_cDEFAULTPORT;
            //oStartDlg.DSNetworkWrapper = m_oGameEngine.DirectPlay;
            //if( oStartDlg.ShowDialog() == System.Windows.Forms.DialogResult.Yes )
            {
                oPleaseWait = new frmPleaseWait();
                oPleaseWait.Show();
                oPleaseWait.Refresh();

                m_sServerName = oStartDlg.Name;
                //oServiceProv = m_oGameEngine.DirectPlay.FindServiceProvider( oStartDlg.ServiceProviderGUID );
                //m_oGameEngine.DirectPlay.HostGame( oServiceProv,m_sServerName,"App Server",oStartDlg.Port );
                m_oGameEngine.DirectPlay.HostGame(m_sServerName, "App Server", 5461/*oStartDlg.Port*/ );

                m_oFileServerUpdater = new FileServerUpdater();
                m_oFileServerUpdater.HostFileVersionServer();

                oPleaseWait.Close();
            }
            /*else
            {
                this.Close();
            }*/
        }
		private void frmMain_Closing(object sender, System.ComponentModel.CancelEventArgs e)
		{
			m_oGameEngine.Dispose();
		}

		private void cmdStartSession_Click(object sender, System.EventArgs e)
		{
			Planet oEarth = null;
			DSNetworkPacket oPacket = null;
			Session oNewSession = null;
			frmStartSession oStartDlg = new frmStartSession();


			//Now start a Session
			oStartDlg.SessionName = "Test Lab " + m_nNextSessionNumberToUse.ToString();
			m_nNextSessionNumberToUse++;

			if( oStartDlg.ShowDialog() == System.Windows.Forms.DialogResult.Yes )
			{
				Globals.Inst().IAmTheServer = true;

				Globals.Inst().PrimaryKey = new DSNetPrimaryKeyGenerator( m_oGameEngine.DirectPlay.Me.SocketID );
				oNewSession = new Session();
				oNewSession.SessionName = oStartDlg.SessionName;
                //Server can't have this global
				//Globals.Inst().Session = oNewSession;
				Globals.Inst().GameEngine = m_oGameEngine;
				Globals.Inst().Network = m_oGameEngine.DirectPlay;

				//Add an earth to all sessions
				oEarth = new Planet();
				oEarth.Pos = new Vector2( (float)( DSMisc.GetRnd() * this.Width - this.Width / 2.0 ),
										  (float)( DSMisc.GetRnd() * this.Height - this.Height / 2.0 ) );
				oEarth.Pos = new Vector2(
                            (float)(DSMisc.GetRnd() * oNewSession.Width - oNewSession.Width / 2.0),
                            (float)(DSMisc.GetRnd() * oNewSession.Height - oNewSession.Height / 2.0));
				//oNewSession.AddEntity( oEarth,false );

				lock( m_oInActiveSessions )
				{
					m_oInActiveSessions.Add( oNewSession.GUID,oNewSession );
				}

				UpdateGUISessionList();
				oPacket = NetMsg.Pckt_AddSession( oNewSession ); 
				SendMsgOnToAllPlayersInLobby( m_oGameEngine.DirectPlay.Me,oPacket );
			}	
		}
		private void cmdStopSession_Click(object sender, System.EventArgs e)
		{
			DSNetworkPlayer oLoopPlayer = null;
			DSNetworkPacket oPacket = null;
			Session oSession = null;
			string sGUID = "";


			sGUID = (string)lvwSessions.SelectedItems[0].Tag;

			lock( m_oActiveSessions )
			{
				if( m_oActiveSessions.ContainsKey( sGUID ) == true )
				{
					oSession = (Session)m_oActiveSessions.GetByKey( sGUID );
					m_oActiveSessions.Remove( sGUID );
				}
			}
			lock( m_oInActiveSessions )
			{
				if( m_oInActiveSessions.ContainsKey( sGUID ) == true )
				{
					oSession = (Session)m_oInActiveSessions.GetByKey( sGUID );
					m_oInActiveSessions.Remove( sGUID );
				}
			}

			//Anyone in that session?  Not anymore
			for( int i=0 ; i<m_oGameEngine.DirectPlay.Players.Count ; i++ )
			{
				if( i>m_oGameEngine.DirectPlay.Players.Count ){ break; }
				oLoopPlayer = (DSNetworkPlayer)m_oGameEngine.DirectPlay.Players.GetByIndex( i );
					
				if( oLoopPlayer.IsMe == false && 
					m_oPlayerSocketIDToSessionGUIDLookup.ContainsKey( oLoopPlayer.SocketID ) == true &&
					(string)m_oPlayerSocketIDToSessionGUIDLookup.GetByKey( oLoopPlayer.SocketID ) == sGUID )
				{
					RemovePlayerFromSession( oLoopPlayer );
				}
			}				


			UpdateGUISessionList();
			oPacket = NetMsg.Pckt_DelSession( oSession ); 
			SendMsgOnToAllPlayersInLobby( m_oGameEngine.DirectPlay.Me,oPacket );
		}
		private void cmdSendLobbyMsg_Click(object sender, System.EventArgs e)
		{
			DSNetworkPacket oPacket = NetMsg.Pckt_LobbyChat( m_oGameEngine.DirectPlay.Me,txtSendMsg.Text );
			txtSendMsg.Text = "";		
			SendMsgOnToAllPlayersInLobby( m_oGameEngine.DirectPlay.Me,oPacket );
		}

		public void Advance(object sender, System.EventArgs e)
		{
			double nElapsedTime = ((DSGameEngineArgs)e).ElapsedTime;
            DSNetworkPacket oPacket = null;
            TimeSpan oSpan = TimeSpan.MinValue;
			DSSortedList oTempSessions = null;
			Session oLoopSession = null;


			this.Text = m_oGameEngine.FrameStats;

            //Check to see if we have any large packets to send
            oSpan = DateTime.Now - m_dtLastLargePacketSend;
            if (oSpan.TotalSeconds > 1 && m_oLargePacketsToSend.Count > 0)
            {
                oPacket = m_oLargePacketsToSend[0];
                m_oLargePacketsToSend.RemoveAt(0);
                m_oGameEngine.DirectPlay.SendMsg(oPacket);
                m_dtLastLargePacketSend = DateTime.Now;
            }

			//Advance all our sessions that have people in them
			lock( m_oActiveSessions )
			{
				oTempSessions = m_oActiveSessions.Clone();
			}
            Globals.Inst().Session = null;
			for( int nSessionIndex=0 ; nSessionIndex<oTempSessions.Count ; nSessionIndex++ )
			{
				oLoopSession = (Session)oTempSessions.GetByIndex( nSessionIndex );
				oLoopSession.Advance( nElapsedTime );
			}
		}
		private void LogEvent( string sEvent )
		{
            if (lstLog.InvokeRequired == true)
            {
                lstLog.Invoke(new DelegateLogEvent(LogEvent), new object[] { sEvent });
            }
            else
            {
                string sTime = DateTime.Now.ToString("yyyy-MM-dd hh:mm:ss") + ": ";
                lstLog.Items.Add(sTime + sEvent);
                lstLog.SelectedIndex = lstLog.Items.Count - 1;
            }
		}
		private void AddChatMsg( DSNetworkPlayer oSenderPlayer,string sMessage )
		{
			//Show it for us too
			if( oSenderPlayer != null )
			{
				lstLog.Items.Add( oSenderPlayer.Name + ": " + sMessage );
			}
			else
			{
				lstLog.Items.Add( "Unknown: " + sMessage );
			}
			lstLog.SelectedIndex = lstLog.Items.Count - 1;
		}

		private void UpdateGUISessionList()
		{
			DSSortedList oTempSessions = null;
			Session oLoopSession = null;
			ListViewItem oItem = null;


			lvwSessions.Items.Clear();

			lock( m_oActiveSessions )
			{
				oTempSessions = m_oActiveSessions.Clone();
			}
			for( int nSessionIndex=0 ; nSessionIndex<oTempSessions.Count ; nSessionIndex++ )
			{
				oLoopSession = (Session)oTempSessions.GetByIndex( nSessionIndex );
				oItem = lvwSessions.Items.Add( oLoopSession.SessionName );
				oItem.SubItems.Add( "0" );
				oItem.Tag = oLoopSession.GUID;
			}

			lock( m_oInActiveSessions )
			{
				oTempSessions = m_oInActiveSessions.Clone();
			}
			for( int nSessionIndex=0 ; nSessionIndex<oTempSessions.Count ; nSessionIndex++ )
			{
				oLoopSession = (Session)oTempSessions.GetByIndex( nSessionIndex );
				oItem = lvwSessions.Items.Add( oLoopSession.SessionName );
				oItem.SubItems.Add( "0" );
				oItem.Tag = oLoopSession.GUID;
			}

			UpdateEnabledStatus();
		}
		private void AddSessionToGUI( Session oSessionToAdd )
		{
			ListViewItem oItem = null;

			oItem = lvwSessions.Items.Add( oSessionToAdd.SessionName );
			oItem.SubItems.Add( "0" );
			oItem.Tag = oSessionToAdd.GUID;

			UpdateSessionPlayerCountInGUID( oSessionToAdd.GUID );
		}
		private void RemoveSessionFromGUI( Session oSessionToRemove )
		{
			int nIndex = GetSessionIndexInListView( oSessionToRemove.GUID );
			if( nIndex != -1 )
			{
				lvwSessions.Items.RemoveAt( nIndex );
			}
		}
		private void lvwSessions_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			UpdateEnabledStatus();
		}
		private void UpdateEnabledStatus()
		{
			cmdStopSession.Enabled = ( lvwSessions.SelectedIndices.Count > 0 );
		}

		private int GetPlayerIndexInListView( long nSocketID )
		{
			ListViewItem oItem = null;


            if (lvwSessions.InvokeRequired == true)
            {
                return( (int)lvwSessions.Invoke(new DelegateGetPlayerIndexInListView(GetPlayerIndexInListView), new object[] { nSocketID }) );
            }
            else
            {
                for (int i = 0; i < lvwUsers.Items.Count; i++)
                {
                    oItem = lvwUsers.Items[i];
                    if ((long)oItem.Tag == nSocketID)
                    {
                        return (i);
                    }
                }
            }


			return( -1 );
		}
		private void UpdateSessionPlayerCountInGUID( string sGUID )
		{
			int nIndex = GetSessionIndexInListView( sGUID );
			if( nIndex != -1 )
			{
				lvwSessions.Items[ nIndex ].SubItems[ 1 ].Text = GetPlayerCountForSession( sGUID ).ToString();
			}
		}
		private int GetSessionIndexInListView( string sGUID )
		{
			ListViewItem oItem = null;

			for( int i=0 ; i<lvwSessions.Items.Count ; i++ )
			{
				oItem = lvwSessions.Items[ i ];
				if( (string)oItem.Tag == sGUID )
				{
					return( i );
				}
			}

			return( -1 );
		}
		private void AddPlayerToSession( DSNetworkPlayer oPlayerToAdd,string sGUID )
		{
			Session oSession = null;


			RemovePlayerFromSession( oPlayerToAdd );
			m_oPlayerSocketIDToSessionGUIDLookup.Add( oPlayerToAdd.SocketID,sGUID );
			MoveSessionBetweenStatus( sGUID,m_oInActiveSessions,m_oActiveSessions );
			UpdateSessionPlayerCountInGUID( sGUID );

			lock( m_oActiveSessions )
			{
				oSession = (Session)m_oActiveSessions.GetByKey( sGUID );
			}
			oSession.AddPlayer( oPlayerToAdd );
		}
		private void RemovePlayerFromSession( DSNetworkPlayer oPlayerToRemove )
		{
			Session oSession = null;
			string sGUID = "";


            if (lvwSessions.InvokeRequired == true)
            {
                lvwSessions.Invoke(new DelegateRemovePlayerFromSession(RemovePlayerFromSession), new object[] { oPlayerToRemove });
            }
            else
            {
			    try
			    {
				    if( m_oPlayerSocketIDToSessionGUIDLookup.ContainsKey( oPlayerToRemove.SocketID ) == true )
				    {
					    sGUID = (string)m_oPlayerSocketIDToSessionGUIDLookup.GetByKey( oPlayerToRemove.SocketID );
					    m_oPlayerSocketIDToSessionGUIDLookup.Remove( oPlayerToRemove.SocketID );

					    lock( m_oActiveSessions )
					    {
						    oSession = (Session)m_oActiveSessions.GetByKey( sGUID );
					    }
					    oSession.RemovePlayer( oPlayerToRemove );

					    if( GetPlayerCountForSession( sGUID ) == 0 )
					    {
						    MoveSessionBetweenStatus( sGUID,m_oActiveSessions,m_oInActiveSessions );
					    }

					    UpdateSessionPlayerCountInGUID( sGUID );
				    }

			    }
			    catch( System.Exception oEx )
			    {
				    DSMisc.ShowErrors( oEx );
			    }
            }
		}

		private void MoveSessionBetweenStatus( string sGUID,DSSortedList oSourceSessions,DSSortedList oTargetSessions )
		{
			Session oSessionToMove = null;


			lock( oSourceSessions )
			{
				oSessionToMove = (Session)oSourceSessions.GetByKey( sGUID );
			}		
			if( oSessionToMove != null )
			{
				lock( oTargetSessions )
				{
					if( oTargetSessions.ContainsKey( sGUID ) == true )
					{
						oTargetSessions.Remove( sGUID );
					}
					oTargetSessions.Add( sGUID,oSessionToMove );
				}
			}
		}
		private long GetPlayerCountForSession( string sGUID )
		{
			DSSortedList oTempList = null;
			long nPlayerCount = 0;


			lock( m_oPlayerSocketIDToSessionGUIDLookup )
			{
				oTempList = m_oPlayerSocketIDToSessionGUIDLookup.Clone();
			}
			for( int i=0 ; i<oTempList.Count ; i++ )
			{
				if( (string)oTempList.GetByIndex( i ) == sGUID )
				{
					nPlayerCount++;
				}
			}


			return( nPlayerCount );
        }

        #region Cross-Thread Control Access
        private void RemoveUser(long nSocketID)
        {
            int nIndex = -1;


            if (lvwUsers.InvokeRequired == true)
            {
                lvwUsers.Invoke(new DelegateRemoveUser(RemoveUser), new object[] { nSocketID });
            }
            else
            {
                nIndex = GetPlayerIndexInListView(nSocketID);

                lvwUsers.Items.RemoveAt(nIndex);
            }
        }
        #endregion

        #region Remoting Functions
        private void DataReceived( DSNetworkPlayer oSendingPlayer,DSNetworkPacket oPacket )
		{
            m_oGameEngine.WriteToDebug(0, "Network Message DataReceived: " + oPacket.MsgType.ToString());


			try
			{
				#region Player maintance messages
				if( oPacket.MsgType == (int)enumNetMsg.IsPatchAvailable )
				{
					AddChatMsg( oSendingPlayer,"Asking for patch availability" );
					string sTheirVersion = "";
					string[] saFilesToUpdate = null;

					NetMsg.Rcv_IsPatchAvailable( oPacket,ref sTheirVersion );
					saFilesToUpdate = m_oFileServerUpdater.GetFilesNeedingUpdateFrom( sTheirVersion );
					NetMsg.Send_PatchAvailabilityResponse( m_oGameEngine.DirectPlay,oSendingPlayer,saFilesToUpdate );
				}
				#endregion
				#region Lobby messages
				else if( oPacket.MsgType == (int)enumNetMsg.LobbyChat )
				{
					long nSenderSocketID = 0;
					string sMessage = "";
					DSNetworkPlayer oSenderPlayer = null;


					NetMsg.Rcv_LobbyChat( oPacket,ref nSenderSocketID,ref sMessage );
					oSenderPlayer = m_oGameEngine.DirectPlay.GetPlayer( nSenderSocketID );

					//Forward the message to anyone not in a session
					AddChatMsg( oSenderPlayer,sMessage );
					SendMsgOnToAllPlayersInLobby( oSenderPlayer,oPacket );
				}
				else if( oPacket.MsgType == (int)enumNetMsg.RequestingSessionList )
				{
					SendPlayerTheSessionList( oSendingPlayer );
				}
				else if( oPacket.MsgType == (int)enumNetMsg.JoinSession )
				{
					int nIndex = -1;
					int nPlayerJoiningsSocketID = 0;
					string sSessionGUID = "";
					Session oSession = null;
					DSNetworkPlayer oJoiningPlayer = null;

					NetMsg.Rcv_JoinSession( oPacket,ref sSessionGUID,ref nPlayerJoiningsSocketID );

					oJoiningPlayer = m_oGameEngine.DirectPlay.GetPlayer( nPlayerJoiningsSocketID );
					AddPlayerToSession( oJoiningPlayer,sSessionGUID );

					//Tell anyone else not in the lobby so they can remove them from their list
					SendMsgOnToAllPlayersInLobby( oSendingPlayer,oPacket );

					//Tell everyone where they areThis session is now active so move it over
					lock( m_oActiveSessions )
					{
						oSession = (Session)m_oActiveSessions.GetByKey( sSessionGUID );
					}		
					if( oSession == null )
					{
						lock( m_oInActiveSessions )
						{
							oSession = (Session)m_oInActiveSessions.GetByKey( sSessionGUID );
						}		

						if( oSession != null )
						{
							lock( m_oInActiveSessions )
							{
								m_oInActiveSessions.Remove( sSessionGUID );
							}
						}
					}

					nIndex = GetPlayerIndexInListView( nPlayerJoiningsSocketID );
					if( oSession != null )
					{
						lvwUsers.Items[ nIndex ].SubItems[ 1 ].Text = oSession.SessionName;
					}
					else
					{
						lvwUsers.Items[ nIndex ].SubItems[ 1 ].Text = "In game";
					}

					//And lastly send them the session
					NetMsg.Send_SessionUpdate( m_oGameEngine.DirectPlay,oSendingPlayer,oSession );
                    NetMsg.Send_ZonesUpdate(m_oGameEngine.DirectPlay, oSendingPlayer, oSession, m_oLargePacketsToSend);
				}
				else if( oPacket.MsgType == (int)enumNetMsg.QuitSession )
				{
					int nIndex = -1;
					int nPlayerQuitingsSocketID = 0;
					string sSessionGUID = "";
					DSNetworkPlayer oPlayerQuiting = null;

					NetMsg.Rcv_QuitSession( oPacket,ref sSessionGUID,ref nPlayerQuitingsSocketID );

					oPlayerQuiting = m_oGameEngine.DirectPlay.GetPlayer( nPlayerQuitingsSocketID );
					RemovePlayerFromSession( oPlayerQuiting );

					//Tell anyone else not in the lobby so they can remove them from their list
					SendMsgOnToAllPlayersInLobby( oSendingPlayer,oPacket );

					//Tell everyone where they are
					nIndex = GetPlayerIndexInListView( nPlayerQuitingsSocketID );
					lvwUsers.Items[ nIndex ].SubItems[ 1 ].Text = "Lobby";
				}
					#endregion
				#region In game messages
				else if( oPacket.MsgType == (int)enumNetMsg.EntityUpdate )
				{
					DSSerialize oSerialize = null;
					Entity oEntity = null;
					Entity oSessionEntity = null;
					Session oSession = null;
					string sSerializedStr = "";
					string sSessionGUID = "";
					string sPKey = "";

					if( m_oPlayerSocketIDToSessionGUIDLookup.ContainsKey( oSendingPlayer.SocketID ) == true )
					{
						sSessionGUID = (string)m_oPlayerSocketIDToSessionGUIDLookup.GetByKey( oSendingPlayer.SocketID );

						//Update this entity
						lock( m_oActiveSessions )
						{
							oSession = (Session)m_oActiveSessions.GetByKey( sSessionGUID );
						}
						if( oSession != null )
						{
							//Update the session
							NetMsg.Rcv_EntityUpdate( oPacket,ref sPKey,ref oEntity,ref sSerializedStr );
							oSessionEntity = oSession.GetEntity( sPKey );
							if( oSessionEntity == null )
							{
								oSerialize = new DSSerialize( sSerializedStr );
								oEntity.DeSerialize( oSession,oSerialize );
                                oEntity.Advance(oSession, oSendingPlayer.LastPingInSeconds);
								oSession.AddEntity( oEntity,false );
							}
							else
							{
								oSerialize = new DSSerialize( sSerializedStr );
                                oSessionEntity.DeSerialize(oSession, oSerialize);
                                oSessionEntity.Advance(oSession, oSendingPlayer.LastPingInSeconds / 2.0f);
                                oSession.ChangeZone(oSessionEntity);
							}
							SendMsgOnToAllPlayersInSession( oSendingPlayer,oPacket,sSessionGUID );
						}
					}
				}
				else if( oPacket.MsgType == (int)enumNetMsg.EntityLiteUpdate )
				{
					Entity oEntity = null;
					string sEntityGUID = "";
					string sSessionGUID = "";
					Session oSession = null;
					Location oClientLocation = null;

					if( m_oPlayerSocketIDToSessionGUIDLookup.ContainsKey( oSendingPlayer.SocketID ) == true )
					{
						sSessionGUID = (string)m_oPlayerSocketIDToSessionGUIDLookup.GetByKey( oSendingPlayer.SocketID );

						//Update this entity
						lock( m_oActiveSessions )
						{
							oSession = (Session)m_oActiveSessions.GetByKey( sSessionGUID );
						}
				
						if( oSession != null )
						{
							//Update the session
							NetMsg.Rcv_EntityLiteUpdate( oPacket,ref sEntityGUID,ref oClientLocation );
							oEntity = oSession.GetEntity( sEntityGUID );

							if( oEntity != null )
							{
								oEntity.Location = new Location( oClientLocation );
                                oEntity.Advance(oSession, oSendingPlayer.LastPingInSeconds / 2.0f);
                                oSession.ChangeZone(oEntity);
							}

							//This is bad, it causes jitters for other players 
							//SendMsgOnToAllPlayersInSession( oSendingPlayer,oPacket,sSessionGUID );
						}
					}
				}
				else if( oPacket.MsgType == (int)enumNetMsg.EntityKeyPress )
				{
					Entity oEntity = null;
					Session oSession = null;
					string sSessionGUID = "";
					string sEntityPKey = "";
					Microsoft.DirectX.DirectInput.Key oKey = Key.Escape;
					bool bPressed = false;

					//Get our data
					NetMsg.Rcv_EntityKeyPress( oPacket,ref sEntityPKey,ref oKey,ref bPressed );

					if( oSendingPlayer != null &&
						m_oPlayerSocketIDToSessionGUIDLookup.ContainsKey( oSendingPlayer.SocketID ) == true )
					{
						//Find our session
						sSessionGUID = (string)m_oPlayerSocketIDToSessionGUIDLookup.GetByKey( oSendingPlayer.SocketID );
						lock( m_oActiveSessions )
						{
							oSession = (Session)m_oActiveSessions.GetByKey( sSessionGUID );
						}

						if( oSession != null )
						{
							//Pass in the ksy stroke
							oEntity = oSession.GetEntity( sEntityPKey );
							if( oEntity != null )
							{
								oEntity.KeyProcess( oSession,oKey,bPressed );
                                oEntity.Advance(oSession, oSendingPlayer.LastPingInSeconds / 2.0f);
							}

							//And pass on to the rest of the session players
							SendMsgOnToAllPlayersInSession( oSendingPlayer,oPacket,sSessionGUID );
						}
					}
				}
				else if( oPacket.MsgType == (int)enumNetMsg.GameChat )
				{
					long nSenderSocketID = 0;
					string sMessage = "";
					string sSessionGUID = "";
					Session oSession = null;

					NetMsg.Rcv_GameChat( oPacket,ref nSenderSocketID,ref sMessage );

					if( m_oPlayerSocketIDToSessionGUIDLookup.ContainsKey( nSenderSocketID ) == true )
					{
						//Find our session
						sSessionGUID = (string)m_oPlayerSocketIDToSessionGUIDLookup.GetByKey( nSenderSocketID );
						lock( m_oActiveSessions )
						{
							oSession = (Session)m_oActiveSessions.GetByKey( sSessionGUID );
						}

						if( oSession != null )
						{
							oSession.CheckForCheatCodes( sMessage );

							//And pass on to the rest of the session players
							AddChatMsg( oSendingPlayer,"InGameMsg: " + sMessage );
							SendMsgOnToAllPlayersInSession( oSendingPlayer,oPacket,sSessionGUID );
						}
					}
				}
				else if( oPacket.MsgType == (int)enumNetMsg.SetEntityInPlayStatus  )
				{
					bool bIsInPlayFlag = false;
					string sSessionGUID = "";
					string sEntityGUID = "";
					Session oSession = null;
					Entity oEntity = null;

					//Find our session
					sSessionGUID = (string)m_oPlayerSocketIDToSessionGUIDLookup.GetByKey( oSendingPlayer.SocketID );
					lock( m_oActiveSessions )
					{
						oSession = (Session)m_oActiveSessions.GetByKey( sSessionGUID );
					}

					if( oSession != null )
					{
						NetMsg.Rcv_SetEntityInPlayStatus( oPacket,ref sEntityGUID,ref bIsInPlayFlag );

						oEntity = oSession.GetEntity( sEntityGUID );
						if( oEntity != null )
						{
							oEntity.IsInPlay = bIsInPlayFlag;

							SendMsgOnToAllPlayersInSession( oSendingPlayer,oPacket,sSessionGUID );
						}
					}
				}
				else if( oPacket.MsgType == (int)enumNetMsg.EntityMessage )
				{
					string sSessionGUID = "";
					string sEntityPKey = "";
					string sIncomingMessage = "";
					long nSubMessageType = 0;
					Session oSession = null;
					Entity oEntity = null;

					//Find our session
					sSessionGUID = (string)m_oPlayerSocketIDToSessionGUIDLookup.GetByKey( oSendingPlayer.SocketID );
					lock( m_oActiveSessions )
					{
						oSession = (Session)m_oActiveSessions.GetByKey( sSessionGUID );
					}

					if( oSession != null )
					{
						NetMsg.Rcv_EntityMessage( oPacket,ref sEntityPKey,ref nSubMessageType,ref sIncomingMessage );

						oEntity = oSession.GetEntity( sEntityPKey );
						oEntity.NetworkMessageReceived( oSession,nSubMessageType,sIncomingMessage );

						SendMsgOnToAllPlayersInSession( oSendingPlayer,oPacket,sSessionGUID );
					}
				}
				else if( oPacket.MsgType == (int)enumNetMsg.RemoveEntity )
				{
					string sSessionGUID = "";
					string sEntityPKey = "";
					Session oSession = null;
					Entity oEntity = null;

					//Find our session
					sSessionGUID = (string)m_oPlayerSocketIDToSessionGUIDLookup.GetByKey( oSendingPlayer.SocketID );
					lock( m_oActiveSessions )
					{
						oSession = (Session)m_oActiveSessions.GetByKey( sSessionGUID );
					}

					if( oSession != null )
					{
						NetMsg.Rcv_RemoveEntity( oPacket,ref sEntityPKey );

						oEntity = oSession.GetEntity( sEntityPKey );
                        if (oEntity != null)
                        {
                            oSession.RemoveEntity(oEntity);

                            //Except if the remove is done by a client... we have to pass it along
                            //This is done by remove entity for us so don't do it again.
                            SendMsgOnToAllPlayersInSession(oSendingPlayer, oPacket, sSessionGUID);
                        }
					}
				}
				#endregion
			}
			catch( System.Exception oEx )
			{
                DSMisc.ShowErrors( oEx );
			} 
		}
		private void PlayerJoined( DSNetworkPlayer oNewPlayer,bool bUs )
		{
			ListViewItem oItem = null;
            

            if (lvwUsers.InvokeRequired == true)
            {
                lvwUsers.Invoke(new DelegatePlayerJoined(PlayerJoined), new object[] { oNewPlayer, bUs });
            }
            else
            {
                if (bUs == true)
                {
                    LogEvent("Server started.");
                }
                else
                {
                    LogEvent(oNewPlayer.Name + " joined.");

                    //Add them to the list
                    oItem = lvwUsers.Items.Add(oNewPlayer.Name);
                    oItem.Tag = oNewPlayer.SocketID;
                    oItem.SubItems.Add("Lobby");
                }
            }
		}
		private void PlayerQuit( DSNetworkPlayer oLeavingPlayer )
		{
			LogEvent( oLeavingPlayer.Name + " quit." );
			RemovePlayerFromSession( oLeavingPlayer );
            RemoveUser(oLeavingPlayer.SocketID);
		}
        
		private void SendPlayerTheSessionList( DSNetworkPlayer oPlayer )
		{
			DSSortedList oTempSessions = null;
			Session oLoopSession = null;


			lock( m_oActiveSessions )
			{
				oTempSessions = m_oActiveSessions.Clone();
			}
			for( int i=0 ; i<oTempSessions.Count ; i++ )
			{
				oLoopSession = (Session)oTempSessions.GetByIndex( i );
				NetMsg.Send_AddSession( m_oGameEngine.DirectPlay,oPlayer,oLoopSession );
			}

			lock( m_oInActiveSessions )
			{
				oTempSessions = m_oInActiveSessions.Clone();
			}
			for( int i=0 ; i<oTempSessions.Count ; i++ )
			{
				oLoopSession = (Session)oTempSessions.GetByIndex( i );
				NetMsg.Send_AddSession( m_oGameEngine.DirectPlay,oPlayer,oLoopSession );
			}
		}
		private void SendPlayerThePlayerList( DSNetworkPlayer oPlayer )
		{
			string sGUID = "";
			DSNetworkPlayer oLoopPlayer = null;
			DSSortedList oTempList = null;


			lock( m_oGameEngine.DirectPlay.Players )
			{
				oTempList = m_oGameEngine.DirectPlay.Players.Clone();
			}
			for( int i=0 ; i<oTempList.Count ; i++ )
			{
				oLoopPlayer = (DSNetworkPlayer)oTempList.GetByIndex( i );
					
				if( oLoopPlayer.IsMe == false && oPlayer.SocketID != oLoopPlayer.SocketID )
				{
					if( m_oPlayerSocketIDToSessionGUIDLookup.ContainsKey( oLoopPlayer.SocketID ) == false )
					{
						NetMsg.Send_QuitSession( m_oGameEngine.DirectPlay,oPlayer,oLoopPlayer,"" );
					}
					else
					{
						sGUID = (string)m_oPlayerSocketIDToSessionGUIDLookup.GetByKey( oLoopPlayer.SocketID );
						NetMsg.Send_JoinSession( m_oGameEngine.DirectPlay,oPlayer,oLoopPlayer,sGUID );
					}
				}
			}	
		}
		private void SendMsgOnToAllPlayersInLobby( DSNetworkPlayer oSenderPlayer,DSNetworkPacket oPacket )
		{
			DSNetworkPlayer oLoopPlayer = null;
			DSSortedList oTempList = null;


			lock( m_oGameEngine.DirectPlay.Players )
			{
				oTempList = m_oGameEngine.DirectPlay.Players.Clone();
			}
			//Forward the message to anyone not in a session
			for( int i=0 ; i<oTempList.Count ; i++ )
			{
				oLoopPlayer = (DSNetworkPlayer)oTempList.GetByIndex( i );
					
				if( oLoopPlayer.IsMe == false && 
					oSenderPlayer.SocketID != oLoopPlayer.SocketID &&
					m_oPlayerSocketIDToSessionGUIDLookup.ContainsKey( oLoopPlayer.SocketID ) == false )
				{
					m_oGameEngine.DirectPlay.SendMsg( oLoopPlayer,oPacket );
				}
			}	
		}
		private void SendMsgOnToAllPlayersInSession( DSNetworkPlayer oSenderPlayer,DSNetworkPacket oPacket,string sSessionGUID )
		{
			DSNetworkPlayer oLoopPlayer = null;
			DSSortedList oTempList = null;


			lock( m_oGameEngine.DirectPlay.Players )
			{
				oTempList = m_oGameEngine.DirectPlay.Players.Clone();
			}
			//Forward the message to anyone not in a session
			for( int i=0 ; i<oTempList.Count ; i++ )
			{
				oLoopPlayer = (DSNetworkPlayer)oTempList.GetByIndex( i );
					
				if( oLoopPlayer.IsMe == false && 
					m_oPlayerSocketIDToSessionGUIDLookup.ContainsKey( oLoopPlayer.SocketID ) == true &&
					(string)m_oPlayerSocketIDToSessionGUIDLookup.GetByKey( oLoopPlayer.SocketID ) == sSessionGUID &&
					(
						oSenderPlayer == null ||
						oSenderPlayer.SocketID != oLoopPlayer.SocketID 
					)
				  )
				{
					m_oGameEngine.DirectPlay.SendMsg( oLoopPlayer,oPacket );
				}
			}	
		}
		#endregion


		#region Properties
		public DSGameEngine DSGameEngine
		{
			get
			{
				return( m_oGameEngine );
			}
			set
			{
				m_oGameEngine = value;
			}
		}
		#endregion
	}
}